openapi: 3.0.3
info:
  title: Acade Lotear
  description: 'Api para operações básicas da Acade Lotear'
  version: 0.5.5
servers:
- url: "<?=$_SERVER['REQUEST_SCHEME']."://".$_SERVER['HTTP_HOST']?>/acadelotear"
tags:
- name: pessoaFisica
  description: Funções destinadas ao cadastro de pessoa física
  externalDocs:
    description: Find out more
    url: http://swagger.io
- name: pessoaJuridica
  description: Funções destinadas ao cadastro de pessoa juridica
  externalDocs:
    description: Find out more
    url: http://swagger.io
- name: contrato
  description: Funções destinadas ao cadastro de contrato
  externalDocs:
    description: Find out more
    url: http://swagger.io
paths:
  /?m=api&c=pessoaFisica:
    get:
      tags:
      - pessoaFisica
      summary: Lista de pessoas físicas
      description: Retorna a lista de pessoas físicas
      operationId: getPessoaFisica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: false
        style: simple
        explode: false
        schema:
          type: string
      - name: draw
        in: query
        required: true
        example: 1
        style: form
        explode: true
        schema:
          type: string
      - name: length
        in: query
        description: quantidade
        example: 10
        required: true
        style: simple
        explode: false
        schema:
          type: integer
      - name: start
        in: query
        description: offset
        required: true
        style: simple
        explode: false
        example: "0"
        schema:
          type: integer
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaFisica
  /?m=api&c=pessoaFisica&a=referencias:
    get:
      tags:
      - pessoaFisica
      summary: IDs para o cadastro
      description: Retorna as referencias para o cadastro da pessoa
      operationId: getReferenciasPessoaFisica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaFisica
  /?m=api&c=pessoaFisica&a=procurarCidade:
    get:
      tags:
      - pessoaFisica
      summary: Procura o ID da cidade
      description: Retorna a lista de cidades
      operationId: getCidadePF
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: nome
        in: query
        description: Nome da cidade
        required: true
        style: form
        explode: true
        schema:
          type: string
        example: João Pe
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaFisica
  /?m=api&c=pessoaFisica&a=procurarPessoaFisicaPorCpf:
    get:
      tags:
      - pessoaFisica
      summary: Procurar pessoa física
      description: Retorna as informações da pessoa
      operationId: procurarPessoaFisica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: cpf
        in: query
        description: CPF da pessoa
        required: true
        style: form
        explode: true
        schema:
          type: string
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaFisica
  /?m=api&c=pessoaFisica&a=adicionar:
    post:
      tags:
      - pessoaFisica
      summary: Adicionar uma pessoa física
      description: Adicionar uma pessoa física
      operationId: adicionarPessoaFisica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      requestBody:
        description: Optional description in *Markdown*
        content:
          application/x-www-form-urlencoded:
            schema:
              $ref: '#/components/schemas/pessoaFisica'
        required: true
      responses:
        "200":
          description: successful operation
      x-swagger-router-controller: PessoaFisica
  /?m=api&c=pessoaJuridica:
    get:
      tags:
      - pessoaJuridica
      summary: Lista de pessoas jurídica
      description: Retorna a lista de pessoas jurídica
      operationId: getPessoaJuridica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: draw
        in: query
        description: quantidade
        example: 1
        required: true
        style: simple
        explode: false
        schema:
          type: integer
      - name: length
        in: query
        description: quantidade
        example: 10
        required: true
        style: simple
        explode: false
        schema:
          type: integer
      - name: start
        in: query
        description: offset
        required: true
        style: simple
        explode: false
        example: "0"
        schema:
          type: integer
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaJuridica
  /?m=api&c=pessoaFisica&a=procurarPessoaJuridicaPorCnpj:
    get:
      tags:
      - pessoaJuridica
      summary: Procurar pessoa jurídica
      description: Retorna as informações da pessoa
      operationId: procurarPessoaJuridica
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: cnpj
        in: query
        description: CNPJ da pessoa
        required: true
        style: form
        explode: true
        schema:
          type: string
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaJuridica
  /?m=api&c=pessoaFisica&a=procurarRepresentante:
    get:
      tags:
      - pessoaJuridica
      summary: Procurar representante para pessoa jurídica
      description: Retorna uma lista de pessoas
      operationId: procurarRepresentantes
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: nome
        in: query
        description: Nome da pessoa
        required: true
        style: form
        explode: true
        schema:
          type: string
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaJuridica
  /?m=api&c=pessoaJuridica&a=procurarCidade:
    get:
      tags:
      - pessoaJuridica
      summary: Procura o ID da cidade
      description: Retorna a lista de cidades
      operationId: getCidadePJ
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: nome
        in: query
        description: Nome da cidade
        required: true
        style: form
        explode: true
        schema:
          type: string
        example: João Pe
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: PessoaJuridica
  /?m=api&c=pessoaJuridica&a=adicionar:
    post:
      tags:
      - pessoaJuridica
      summary: Adicionar uma pessoa jurídica
      description: Chamada adiciona um nova pessoa jurídica
      operationId: adicionarPJ
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      requestBody:
        description: Optional description in *Markdown*
        content:
          application/x-www-form-urlencoded:
            schema:
              $ref: '#/components/schemas/pessoaJuridica'
        required: true
      responses:
        "200":
          description: successful operation
      x-swagger-router-controller: PessoaJuridica
  /?m=api&c=contrato:
    get:
      tags:
      - contrato
      summary: Lista de contratos
      description: Retorna a lista de contratos
      operationId: getContratos
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: draw
        in: query
        description: quantidade
        example: 1
        required: true
        style: simple
        explode: false
        schema:
          type: integer
      - name: length
        in: query
        description: quantidade
        example: 10
        required: true
        style: simple
        explode: false
        schema:
          type: integer
      - name: start
        in: query
        description: offset
        required: true
        style: simple
        explode: false
        example: "0"
        schema:
          type: integer
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=empreendimentos:
    get:
      tags:
      - contrato
      summary: Lista de empreendimentos
      description: Retorna a lista de empreendimento
      operationId: getEmpreendimentoContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=corretorPorEmpreendimento:
    get:
      tags:
      - contrato
      summary: Lista de corretores do empreendimentos
      description: Retorna a lista de corretores
      operationId: getCorretoresEmpreendimentoContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: id_empreendimento
        in: query
        description: ID do empreendimento
        required: true
        style: form
        explode: true
        schema:
          type: integer
        example: 48
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=bancoPorEmpreendimento:
    get:
      tags:
      - contrato
      summary: Lista de bancos do empreendimentos
      description: Retorna a lista de bancos
      operationId: getBancosEmpreendimentoContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: id_empreendimento
        in: query
        description: ID do empreendimento
        required: true
        style: form
        explode: true
        schema:
          type: integer
        example: 48
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=indicesPorEmpreendimento:
    get:
      tags:
      - contrato
      summary: Lista de índice do empreendimentos
      description: Retorna a lista de índice
      operationId: getIndiceEmpreendimentoContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: id_empreendimento
        in: query
        description: ID do empreendimento
        required: true
        style: form
        explode: true
        schema:
          type: integer
        example: 48
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=lotePorEmpreendimento:
    get:
      tags:
      - contrato
      summary: Lista de lotes do empreendimentos
      description: Retorna a lista de lotes
      operationId: getLotesEmpreendimentoContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      - name: id_empreendimento
        in: query
        description: ID do empreendimento
        required: true
        style: form
        explode: true
        schema:
          type: integer
        example: 48
      responses:
        "200":
          description: successful operation
        "400":
          description: Invalid ID supplied
        "404":
          description: Pet not found
      x-swagger-router-controller: contrato
  /?m=api&c=contrato&a=adicionar:
    post:
      tags:
      - contrato
      summary: Adicionar um contrato
      description: Adicionar um contrato
      operationId: adicionarContrato
      parameters:
      - name: Token-Acade
        in: header
        description: $Token
        required: true
        style: simple
        explode: false
        schema:
          type: string
      requestBody:
        description: Optional description in *Markdown*
        content:
          application/x-www-form-urlencoded:
            schema:
              $ref: '#/components/schemas/contrato'
        required: true
      responses:
        "200":
          description: successful operation
      x-swagger-router-controller: contrato
  
components:
  schemas:
    pessoaJuridica:
      type: object
      properties:
        nr_cnpj:
          type: string
          example: 12.345.678/0001-90
        nm_pessoa:
          type: string
          example: Empresa
        nm_fantasia:
          type: string
          example: 1.385.123
        nr_inscricao_municipal:
          type: string
          example: Brasileira
        nr_inscricao_estadual:
          type: string
          description: Lista obtida na chamada de referências
          example: M
        email:
          type: string
          description: Lista obtida na chamada de referências
          example: CAS
        nr_telefone:
          type: string
          example: (83) 981234-5678
        nr_celular:
          type: string
          example: (83) 981234-5678
        nr_recado:
          type: string
          example: (83) 981234-5678
        nr_cep:
          type: string
          example: 12345-678
        endereco:
          type: string
          example: Rua A
        nr_endereco:
          type: string
          example: "182"
        ds_complemento:
          type: string
          example: complemento do endereço
        nm_bairro:
          type: string
          example: Bairro
        cd_cidade:
          type: integer
          description: Id obtido na chamada de busca de endereço
          example: 2506301
        ds_observacao:
          type: string
          example: Observação
        representantes[0]:
          type: integer
          description: "Id da pessoa representante da empresa, pode ter mais de um,\
            \ alterar um index do array, representante 0"
          example: 10414
        representantes[1]:
          type: integer
          description: "Id da pessoa representante da empresa, pode ter mais de um,\
            \ alterar um index do array, representante 1, continar o array caso tenha\
            \ mais representantes"
          example: 10415
    contrato:
      type: object
      properties:
        empreendimento:
          type: integer
          description: Id do empreendimento
          example: 48
        idIndice:
          type: integer
          description: Id do índice
          example: 162
        lote:
          type: integer
          description: Id do lote
          example: 23347
        banco:
          type: integer
          description: Id do banco
          example: 93
        cliente:
          type: integer
          description: Id da pessoa, comprador principal
          example: 10414
        participacao:
          type: integer
          description: Participação do comprador principal, a soma de dos os compradores precisa ser igual a 100%
          example: 55
        listaIndices[0]:
          type: string
          description: String contendo os dados do comprador secundário, no padrão "$contador_$nome_$porcentagemParticipação_$idPessoa"
          example: 1_Carlos Davi_25_10285
        listaIndices[1]:
          type: string
          description: String contendo os dados do comprador secundário, no padrão "$contador_$nome_$porcentagemParticipação_$idPessoa"
          example: 2_Maik Carlos de Souza Farias_20_1506
        corretor:
          type: integer
          description: Id do corretor
          example: 1668
        nrProposta:
          type: string
          example: número da prosposta
        dsIntermediacaoImobiliaria:
          type: string
          description: Intermediação imobiliárias
          example: Intermediação
        data:
          type: string
          description: Data do contrato
          example: 15/05/2023
        desconto:
          type: integer
          example: 9
        tp_pagamento:
          type: integer
          description: desconto do contrato
          example: 9
        tp_parcelamento:
          type: string
          description: tipo de pagamento, só as siglas sem os a descrição
          enum:
            - PC (parcelado)
            - AV (avista)
            - PM (permuta)
          example: PC (parcelado)
        vlDivida:
          type: string
          description: valor da dívida
        qtMeses:
          type: integer
          description: quatidade de meses
        txJuros:
          type: string
          description: taxa de juros
        vlrDivida:
          type: string
          example: valor dívida tabela Sacoc
        qtdMeses:
          type: string
          description: quatidade de meses tabela Sacoc
        txsJuros:
          type: string
          description: taxa de juros tabela Sacoc
        vl_parcela:
          type: string
          description: valor da parcela
          example: 100,00
        qtd_parcela:
          type: integer
          description: quatidade de parcelas
          example: 50
        dt_primeira:
          type: string
          example: 01/06/2023
        fl_reajustavel_mensais:
          type: integer
          example: 1
        dt_reajuste_mensal:
          type: string
          example: 30/06/2023
        desconto_tp_normal:
          type: string
          description: tipo de desconto, só as siglas sem os a descrição
          enum:
            - S (Sem desconto)
            - P (Porcentagem)
            - V (valor)
          example: S (Sem desconto)
        valor_desconto_normal:
          type: string
        vl_parcela_adicional[]:
          type: string
        qtd_parcela_adicional[]:
          type: string
        vlSinal:
          type: string
          example: 2.500,00
        qtdSinal:
          type: integer
          example: 2
        incluiSinalContrato:
          type: integer
          example: 1
        desconto_tp_sinal:
          type: string
          description: tipo de desconto, só as siglas sem os a descrição
          enum:
            - S (Sem desconto)
            - P (Porcentagem)
            - V (valor)
          example: S (Sem desconto)
        valor_desconto_sinal:
          type: string
        vl_sinal[0]:
          type: string
          example: 1250
        dt_sinal[0]:
          type: string
          example: 16/05/2023
        vl_sinal[1]:
          type: string
          example: 1250
        dt_sinal[1]:
          type: string
          example: 31/05/2023
        intercalada:
          type: string
          example: 80
        qtd_parcela_intercalada:
          type: string
          example: 12
        frequencia:
          type: string
          example: 3
        fl_reajustavel_intercaladas:
          type: integer
          example: 1
        dt_reajuste_intercalada:
          type: string
          example: 31/07/2023
        desconto_tp_intercalada:
          type: string
          description: tipo de desconto, só as siglas sem os a descrição
          enum:
            - S (Sem desconto)
            - P (Porcentagem)
            - V (valor)
          example: S (Sem desconto)
        valor_desconto_intercalada:
          type: string
        data_intercalada:
          type: string
          example: 01/06/2023
        coincidir:
          type: integer
          example: 1
        vl_intercalada_adicional[0]:
          type: string
        qtd_intercalada_adicional[0]:
          type: string
        fr_intercalada_adicional[0]:
          type: string
        dt_intercalada_adicional[0]:
          type: string
        vl_chaves:
          type: string
          example: 4.000,00
        qtd_parcela_chaves:
          type: integer
          example: 4
        dt_chaves:
          type: string
          example: 08/06/2023
        fl_reajustavel_chaves:
          type: integer
          example: 1
        dt_reajuste_chave:
          type: string
        desconto_tp_chave:
          type: string
          description: tipo de desconto, só as siglas sem os a descrição
          enum:
            - S (Sem desconto)
            - P (Porcentagem)
            - V (valor)
          example: S (Sem desconto)
        valor_desconto_chave:
          type: string
        vl_chave_adicional[0]:
          type: string
        qtd_chave_adicional[0]:
          type: string
        dt_reajuste:
          type: string
          example: 01/06/2023
        obs:
          type: string
          example: Observação
    pessoaFisica:
      type: object
      properties:
        nr_cpf:
          type: string
          example: 123.456.789-83
        nm_pessoa:
          type: string
          example: Joãozinho
        tpDocumento:
          type: integer
          description: Id obtido na chamada de referências
          example: 1
        nr_rg:
          type: string
          example: 1.385.123
        tpNacionalidade:
          type: string
          description: B para brasileiro
          example: B
        nm_nacionalidade:
          type: string
          example: Brasileira
        sexo:
          type: string
          description: Lista obtida na chamada de referências
          example: M
        est_civil:
          type: string
          description: Lista obtida na chamada de referências
          example: CAS
        reg_casamento:
          type: string
          description: Lista obtida na chamada de referências
          example: CE
        nm_profissao:
          type: string
          example: Dev
        dt_nascimento:
          type: string
          example: 30/04/2023
        cidade_nasc:
          type: integer
          description: Id obtido na chamada de busca de endereço
          example: 2506301
        nm_pai:
          type: string
          example: João
        nm_mae:
          type: string
          example: Maria
        email:
          type: string
          example: mail@mail.com
        nr_telefone:
          type: string
          example: (83) 981234-5678
        nr_celular:
          type: string
          example: (83) 981234-5678
        nr_recado:
          type: string
          example: (83) 981234-5678
        nr_cep:
          type: string
          example: 12345-678
        endereco:
          type: string
          example: Rua A
        nr_endereco:
          type: string
          example: "182"
        ds_complemento:
          type: string
          example: complemento do endereço
        nm_bairro:
          type: string
          example: Bairro
        cd_cidade:
          type: integer
          description: Id obtido na chamada de busca de endereço
          example: 2506301
        nm_cd_internacional:
          type: string
          description: Deixar vazio para cidade nacional
          example: ""
        ds_observacao:
          type: string
          example: Observação
        idConjuge:
          type: integer
          description: "id da pessoa do conjuge caso esteja cadastrado no sistema,\
            \ se o estado civil for cas ou une é obrigatório os próximos passos sã\
            o obrigatório, caso não passe o id será criado um cadastro de pessoa para\
            \ o conjuge automaticamente"
          example: 954
        nrCpfConjuge:
          type: string
          example: 123.456.789-83
        nmConjuge:
          type: string
          example: josefa
        sexoConjuge:
          type: string
          description: Lista obtida na chamada de referências
          example: F
        tpDocumentoConjuge:
          type: integer
          description: Lista obtida na chamada de referências
          example: 1
        nrRgConjuge:
          type: string
          example: 8.654.321
        tpNacionalidadeConjuge:
          type: string
          example: B
        nmNacionalidadeConjuge:
          type: string
          example: Brasileira
        nmProfissaoConjuge:
          type: string
          example: Vendedora
        dtNascimentoConjuge:
          type: string
          example: 25/01/2000
        cidade_nascConjuge:
          type: integer
          description: Id obtido na chamada de busca de endereço
          example: 2506301
        utilizarEnderecoConjuge:
          type: integer
          example: 0
        nrCepConjuge:
          type: string
          example: 12345-123
        enderecoConjuge:
          type: string
          example: Rua B
        nr_enderecoConjuge:
          type: string
          example: "123"
        ds_complementoConjuge:
          type: string
          example: Comple.
        nmBairroConjuge:
          type: string
          example: Bairro
        cidadeConjuge:
          type: integer
          description: Id obtido na chamada de busca de endereço
          example: 2506301
      xml:
        name: order
