<?php

class Payload {

    const ID_PAYLOAD_FORMAT_INDICATOR = '00';
    const ID_MERCHANT_ACCOUNT_INFORMATION = '26';
    const ID_MERCHANT_ACCOUNT_INFORMATION_GUI = '00';
    const ID_MERCHANT_ACCOUNT_INFORMATION_KEY = '01';
    const ID_MERCHANT_ACCOUNT_INFORMATION_DESCRIPTION = '02';
    const ID_MERCHANT_CATEGORY_CODE = '52';
    const ID_TRANSACTION_CURRENCY = '53';
    const ID_TRANSACTION_AMOUNT = '54';
    const ID_COUNTRY_CODE = '58';
    const ID_MERCHANT_NAME = '59';
    const ID_MERCHANT_CITY = '60';
    const ID_ADDITIONAL_DATA_FIELD_TEMPLATE = '62';
    const ID_ADDITIONAL_DATA_FIELD_TEMPLATE_TXID = '05';
    const ID_CRC16 = '63';

    /**
     * Chave pix
     * string
     */
    private $pixKey;

    /**
     * Descrio do pagamento
     * string
     */
    private $description;

    /**
     * Nome do titular da conta
     * string
     */
    private $merchantName;

    /**
     * Nome da cidade do titular
     * string
     */
    private $merchantCity;

    /**
     * ID da transao
     * string
     */
    private $txid;

    /**
     * Valor da transao
     * string
     */
    private $amount;

    public function setPixKey($pixKey) {
        $this->pixKey = $pixKey;
        return $this;
    }

    public function setDescription($description) {
        $this->description = $description;
        return $this;
    }

    public function setMerchantName($merchantName) {
        $this->merchantName = $merchantName;
        return $this;
    }

    public function setMerchantCity($merchantCity) {
        $this->merchantCity = $merchantCity;
        return $this;
    }

    public function setTxid($txid) {
        $this->txid = $txid;
        return $this;
    }

    public function setAmount($amount) {
        $this->amount = (string)number_format($amount, 2, '.', '');
        return $this;
    }

    /**
     * Mtodo responsvel pode retornar o valor completo de um objeto do payload
     */
    private function getValue($id, $value) {
        $size = str_pad(strlen($value), 2, '0', STR_PAD_LEFT);
        return $id.$size.$value;
    }

    /**
     * Mtodo responsvel por retornar os valore completos da informao da conta
     */
    private function getMerchantAccountInformation() {
        //DOMNIO DO BANCO
        $gui = $this->getValue(self::ID_MERCHANT_ACCOUNT_INFORMATION_GUI, 'br.gov.bcb.pix');

        //CHAVE PIX
        $key = $this->getValue(self::ID_MERCHANT_ACCOUNT_INFORMATION_KEY, $this->pixKey);

        //DESCTIO DO PAGAMENTO
        $description = strlen($this->description) ? $this->getValue(self::ID_MERCHANT_ACCOUNT_INFORMATION_DESCRIPTION, $this->description) : '';

        //VALOR COMPLETO DA CONTA
        return $this->getValue(self::ID_MERCHANT_ACCOUNT_INFORMATION, $gui.$key.$description);
    }

    /**
     * Mtodo responsvel por retornar os valores completos do campo adicional do pix (TXID)
     */
    private function getAdditionalDataFieldTemplate() {
        //TXID
        $txid = $this->getValue(self::ID_ADDITIONAL_DATA_FIELD_TEMPLATE_TXID, $this->txid);

        //RETORNA O VALOR COMPLETO
        return $this->getValue(self::ID_ADDITIONAL_DATA_FIELD_TEMPLATE, $txid);
    }

    /**
     * Mtodo responsvel por gerar o payload completo do pix
     */
    public function getPayload() {
        
        $payload = $this->getValue(self::ID_PAYLOAD_FORMAT_INDICATOR, '01').
                    $this->getMerchantAccountInformation().
                    $this->getValue(self::ID_MERCHANT_CATEGORY_CODE, '0000').
                    $this->getValue(self::ID_TRANSACTION_CURRENCY, '986').
                    $this->getValue(self::ID_TRANSACTION_AMOUNT, $this->amount).
                    $this->getValue(self::ID_COUNTRY_CODE, 'BR').
                    $this->getValue(self::ID_MERCHANT_NAME, $this->merchantName).
                    $this->getValue(self::ID_MERCHANT_CITY, $this->merchantCity).
                    $this->getAdditionalDataFieldTemplate();

        //RETORNA O PAYLOAD + CRC16
        return $payload.$this->getCRC16($payload);
    }

    /**
   * Mtodo responsvel por calcular o valor da hash de validao do cdigo pix
   * @return string
   */
    private function getCRC16($payload) {
        //ADICIONA DADOS GERAIS NO PAYLOAD
        $payload .= self::ID_CRC16.'04';

        //DADOS DEFINIDOS PELO BACEN
        $polinomio = 0x1021;
        $resultado = 0xFFFF;

        //CHECKSUM
        if (($length = strlen($payload)) > 0) {

            for ($offset = 0; $offset < $length; $offset++) {
                $resultado ^= (ord($payload[$offset]) << 8);
                for ($bitwise = 0; $bitwise < 8; $bitwise++) {
                    if (($resultado <<= 1) & 0x10000) $resultado ^= $polinomio;
                    $resultado &= 0xFFFF;
                }
            }
        }

        //RETORNA CDIGO CRC16 DE 4 CARACTERES
        return self::ID_CRC16.'04'.strtoupper(dechex($resultado));
    }

    public static function removeCaracteresEspeciais($string) {

        // matriz de entrada
        $stringDeEntrada = array( 
        '','','','','',
        '','','','',
        '','','',
        '','','','','',
        '','','','',
        '','','','',
        '','','',
        '','','',
        '','','','',
        '','','',
        '','',
        '','',
        ' ','-','(',')',',',';',':','|','!','"','#','$','%','&','/','=','?','~','^','>','<','','' );
    
        // matriz de sada
        $stringDeSaida   = array(
        'a','a','a','a','a',
        'e','e','e','e',
        'i','i','i',
        'o','o','o','o','o',
        'u','u','u','u',
        'A','A','A','A',
        'E','E','E',
        'I','I','I',
        'O','O','O','O',
        'U','U','U',
        'n','n',
        'c','C',
        '_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_','_' );
    
        // devolver a string
        return str_replace($stringDeEntrada, $stringDeSaida, $string);
    }
}
