<?php

$codigobanco = "077";
$codigo_banco_com_dv = geraCodigoBanco($codigobanco);
$nummoeda = "9";
$fator_vencimento = fator_vencimento($dadosboleto["data_vencimento"]);
//valor tem 10 digitos, sem virgula
$valor = formata_numero($dadosboleto["valor_boleto"], 10, 0, "valor");
//agencia  sempre 4 digitos
$agencia = formata_numero($dadosboleto["agencia"], 4, 0);
//conta  sempre 8 digitos
$conta = formata_numero($dadosboleto["conta"], 8, 0);
//carteira 18
$carteira = $dadosboleto["carteira"];
//agencia e conta
$agencia_codigo = $agencia . "-" . modulo_11($agencia) . " / " . $conta . "-" . modulo_11($conta);
//Zeros: usado quando convenio de 7 digitos
$livre_zeros = '000000';
$dadosboleto["codigo_barras"] = $dadosboleto["codigo_barras"];
$dadosboleto["linha_digitavel"] = formatar_linha_digitavel($dadosboleto["linha_digitavel"]);
$dadosboleto["agencia_codigo"] = $agencia_codigo;
$dadosboleto["codigo_banco_com_dv"] = $codigo_banco_com_dv;


// FUNES
// Algumas foram retiradas do Projeto PhpBoleto e modificadas para atender as particularidades de cada banco

function formata_numero($numero, $loop, $insert, $tipo = "geral")
{
    if ($tipo == "geral") {
        $numero = str_replace(",", "", $numero);
        while (strlen($numero) < $loop) {
            $numero = $insert . $numero;
        }
    }
    if ($tipo == "valor") {
        /*
        retira as virgulas
        formata o numero
        preenche com zeros
        */
        $numero = str_replace(",", "", $numero);
        while (strlen($numero) < $loop) {
            $numero = $insert . $numero;
        }
    }
    if ($tipo == "convenio") {
        while (strlen($numero) < $loop) {
            $numero = $numero . $insert;
        }
    }
    return $numero;
}


function fbarcode($valor)
{
    $fino = 1;
    $largo = 3;
    $altura = 60;

    $barcodes[0] = "00110";
    $barcodes[1] = "10001";
    $barcodes[2] = "01001";
    $barcodes[3] = "11000";
    $barcodes[4] = "00101";
    $barcodes[5] = "10100";
    $barcodes[6] = "01100";
    $barcodes[7] = "00011";
    $barcodes[8] = "10010";
    $barcodes[9] = "01010";
    for ($f1 = 9; $f1 >= 0; $f1--) {
        for ($f2 = 9; $f2 >= 0; $f2--) {
            $f = ($f1 * 10) + $f2;
            $texto = "";
            for ($i = 1; $i < 6; $i++) {
                $texto .= substr($barcodes[$f1], ($i - 1), 1) . substr($barcodes[$f2], ($i - 1), 1);
            }
            $barcodes[$f] = $texto;
        }
    }


//Desenho da barra


//Guarda inicial
    ?><img src=imagens/p.png width=<?php echo $fino ?> height=<?php echo $altura ?> border=0><img
    src=imagens/b.png width=<?php echo $fino ?> height=<?php echo $altura ?> border=0><img
    src=imagens/p.png width=<?php echo $fino ?> height=<?php echo $altura ?> border=0><img
    src=imagens/b.png width=<?php echo $fino ?> height=<?php echo $altura ?> border=0><img
    <?php
    $texto = $valor;
    if ((strlen($texto) % 2) <> 0) {
        $texto = "0" . $texto;
    }

// Draw dos dados
    while (strlen($texto) > 0) {
        $i = round(esquerda($texto, 2));
        $texto = direita($texto, strlen($texto) - 2);
        $f = $barcodes[$i];
        for ($i = 1; $i < 11; $i += 2) {
            if (substr($f, ($i - 1), 1) == "0") {
                $f1 = $fino;
            } else {
                $f1 = $largo;
            }
            ?>
            src=imagens/p.png width=<?php echo $f1 ?> height=<?php echo $altura ?> border=0><img
                <?php
                if (substr($f, $i, 1) == "0") {
                    $f2 = $fino;
                } else {
                    $f2 = $largo;
                }
                ?>
                src=imagens/b.png width=<?php echo $f2 ?> height=<?php echo $altura ?> border=0><img
        <?php
        }
    }

// Draw guarda final
    ?>
    src=imagens/p.png width=<?php echo $largo ?> height=<?php echo $altura ?> border=0><img
    src=imagens/b.png width=<?php echo $fino ?> height=<?php echo $altura ?> border=0><img
    src=imagens/p.png width=<?php echo 1 ?> height=<?php echo $altura ?> border=0>
<?php
} //Fim da funo

function esquerda($entra, $comp)
{
    return substr($entra, 0, $comp);
}

function direita($entra, $comp)
{
    return substr($entra, strlen($entra) - $comp, $comp);
}

function fator_vencimento($data)
{
    $data = explode("/", $data);
    $ano = $data[2];
    $mes = $data[1];
    $dia = $data[0];
    $resultado = (abs((_dateToDays("1997", "10", "07")) - (_dateToDays($ano, $mes, $dia))));
    if ($resultado > 9999) {
        $resultado = (abs((_dateToDays("2025", "02", "22")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
        if ($resultado > 9999) {
            $resultado = (abs((_dateToDays("2052", "07", "08")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
            if ($resultado > 9999) {
                $resultado = (abs((_dateToDays("2079", "11", "23")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
            }
        }
    }
    return $resultado;
}

function _dateToDays($year, $month, $day)
{
    $century = substr($year, 0, 2);
    $year = substr($year, 2, 2);
    if ($month > 2) {
        $month -= 3;
    } else {
        $month += 9;
        if ($year) {
            $year--;
        } else {
            $year = 99;
            $century--;
        }
    }

    return (floor((146097 * $century) / 4) +
        floor((1461 * $year) / 4) +
        floor((153 * $month + 2) / 5) +
        $day + 1721119);
}

/*
#################################################
FUNO DO MDULO 10 RETIRADA DO PHPBOLETO

ESTA FUNO PEGA O DGITO VERIFICADOR DO PRIMEIRO, SEGUNDO
E TERCEIRO CAMPOS DA LINHA DIGITVEL
#################################################
*/
function modulo_10($num)
{
    $numtotal10 = 0;
    $fator = 2;

    for ($i = strlen($num); $i > 0; $i--) {
        $numeros[$i] = substr($num, $i - 1, 1);
        $parcial10[$i] = $numeros[$i] * $fator;
        $numtotal10 .= $parcial10[$i];
        if ($fator == 2) {
            $fator = 1;
        } else {
            $fator = 2;
        }
    }

    $soma = 0;
    for ($i = strlen($numtotal10); $i > 0; $i--) {
        $numeros[$i] = substr($numtotal10, $i - 1, 1);
        $soma += $numeros[$i];
    }
    $resto = $soma % 10;
    $digito = 10 - $resto;
    if ($resto == 0) {
        $digito = 0;
    }

    return $digito;
}

/*
#################################################
FUNO DO MDULO 11 RETIRADA DO PHPBOLETO

MODIFIQUEI ALGUMAS COISAS...

ESTA FUNO PEGA O DGITO VERIFICADOR:

NOSSONUMERO
AGENCIA
CONTA
CAMPO 4 DA LINHA DIGITVEL
#################################################
*/

function modulo_11($num, $base = 9, $r = 0)
{
    $soma = 0;
    $fator = 2;
    for ($i = strlen($num); $i > 0; $i--) {
        $numeros[$i] = substr($num, $i - 1, 1);
        $parcial[$i] = $numeros[$i] * $fator;
        $soma += $parcial[$i];
        if ($fator == $base) {
            $fator = 1;
        }
        $fator++;
    }
    if ($r == 0) {
        $soma *= 10;
        $digito = $soma % 11;

        //corrigido
        if ($digito == 10) {
            $digito = "X";
        }

        /*
        alterado por mim, Daniel Schultz

        Vamos explicar:

        O mdulo 11 s gera os digitos verificadores do nossonumero,
        agencia, conta e digito verificador com codigo de barras (aquele que fica sozinho e triste na linha digitvel)
        s que  foi um rolo...pq ele nao podia resultar em 0, e o pessoal do phpboleto se esqueceu disso...

        No BB, os dgitos verificadores podem ser X ou 0 (zero) para agencia, conta e nosso numero,
        mas nunca pode ser X ou 0 (zero) para a linha digitvel, justamente por ser totalmente numrica.

        Quando passamos os dados para a funo, fica assim:

        Agencia = sempre 4 digitos
        Conta = at 8 dgitos
        Nosso nmero = de 1 a 17 digitos

        A unica varivel que passa 17 digitos  a da linha digitada, justamente por ter 43 caracteres

        Entao vamos definir ai embaixo o seguinte...

        se (strlen($num) == 43) { no deixar dar digito X ou 0 }
        */

        if (strlen($num) > "40") {
            //ento estamos checando a linha digitvel
            if ($digito == "0" || $digito == "X" || $digito > 9) {
                $digito = 1;
            }
        }
        return $digito;
    } elseif ($r == 1) {
        $resto = $soma % 11;
        return $resto;
    }
}

/*
Montagem da linha digitvel - Funo tirada do PHPBoleto
No mudei nada
*/
function formatar_linha_digitavel($linha)
{
 
    return substr($linha, 0, 5).".".substr($linha, 5, 5)." ".
            substr($linha, 10, 5).".".substr($linha, 15, 6)." ".
            substr($linha, 21, 5).".".substr($linha, 26, 6)." ".
            substr($linha, 32, 1)." ".
            substr($linha, 33, 14);
}

function geraCodigoBanco($numero)
{
    $parte1 = substr($numero, 0, 3);
    $parte2 = modulo_11($parte1);
    return $parte1 . "-" . $parte2;
}
?>
