<?php
// +----------------------------------------------------------------------+
// | BoletoPhp - Verso Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo est disponvel sob a Licena GPL disponvel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voc deve ter recebido uma cpia da GNU Public License junto com     |
// | esse pacote; se no, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboraes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joo Prado Maia e Pablo Martins F. Costa                |
// |                                                                      |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Equipe Coordenao Projeto BoletoPhp: <boletophp@boletophp.com.br>   |
// | Desenvolvimento Boleto BANCOOB/SICOOB: Marcelo de Souza              |
// | Ajuste de algumas rotinas: Anderson Nuernberg                        |
// +----------------------------------------------------------------------+

$codigobanco = "756";
$codigo_banco_com_dv = geraCodigoBanco($codigobanco);
$nummoeda = "9";
$fator_vencimento = fator_vencimento($dadosboleto["data_vencimento"]);
$valor = formata_numero($dadosboleto["valor_boleto"],10,0,"valor"); //valor tem 10 digitos, sem virgula
$agencia = formata_numero($dadosboleto["agencia"],4,0); //agencia  sempre 4 digitos
$conta = formata_numero($dadosboleto["conta"],8,0); //conta  sempre 8 digitos
$carteira = $dadosboleto["carteira"];
$modalidadecobranca = $dadosboleto["modalidade_cobranca"];
$numeroparcela      = $dadosboleto["numero_parcela"];
$cedente = formata_numero($dadosboleto["cd_cedente"],7,0);
//Exibe a agencia e cedente separando o ultimo digito do cedente por hfen, "Ex: 999/888-8"
$agencia_codigo = $agencia ." / ". substr($cedente, 0, -1).'-'.substr($cedente, -1); //agencia e conta

// Transforma o nosso numero em inteiro, depois remove o digito verificador(ultimo digito)
// e acrescenta zeros a esquerda se for menor que 8 digitos
$nossonumero = str_pad(substr((int)$dadosboleto["nosso_numero"],0,8), 8, '0', STR_PAD_LEFT);
//Gera o digito verificador
$dv=modulo_11("$codigobanco$nummoeda$fator_vencimento$valor$carteira$agencia$modalidadecobranca$cedente$nossonumero$numeroparcela");
$linha="$codigobanco$nummoeda$dv$fator_vencimento$valor$carteira$agencia$modalidadecobranca$cedente$nossonumero$numeroparcela";
$dadosboleto["codigo_barras"] = $linha;
$dadosboleto["linha_digitavel"] = monta_linha_digitavel($linha);
$dadosboleto["agencia_codigo"] = $agencia_codigo;
$dadosboleto["nosso_numero"] = str_pad(substr((int)$dadosboleto["nosso_numero"], 0, -1), 10, '0', STR_PAD_LEFT).'-'.substr($dadosboleto["nosso_numero"], -1);
$dadosboleto["codigo_banco_com_dv"] = $codigo_banco_com_dv;

/**
 * Formata o nmero de acordo com os tipos passados retornando apenas o pedao da string informado
 * geral = remove virgulas, hifens e retorna o pedao
 * valor = remove virgulas
 * convenio = remove
 */
function formata_numero($numero,$loop,$insert,$tipo = "geral") {
    //remove virgulas
    if ($tipo == "geral") {
        $numero = str_replace("-","",str_replace(",","",$numero));
        while(strlen($numero)<$loop){
            $numero = $insert . $numero;
        }
    } elseif ($tipo == "valor") {
        /*
        retira as virgulas
        formata o numero
        preenche com zeros
        */
        $numero = str_replace(",","",$numero);
        while(strlen($numero)<$loop){
            $numero = $insert . $numero;
        }
    } elseif ($tipo == "convenio") {
        while(strlen($numero)<$loop){
            $numero = $numero . $insert;
        }
    }
    return $numero;
}


function fbarcode($valor){

    $fino = 1 ;
    $largo = 3 ;
    $altura = 50 ;

    $barcodes[0] = "00110" ;
    $barcodes[1] = "10001" ;
    $barcodes[2] = "01001" ;
    $barcodes[3] = "11000" ;
    $barcodes[4] = "00101" ;
    $barcodes[5] = "10100" ;
    $barcodes[6] = "01100" ;
    $barcodes[7] = "00011" ;
    $barcodes[8] = "10010" ;
    $barcodes[9] = "01010" ;
    for($f1=9;$f1>=0;$f1--){
        for($f2=9;$f2>=0;$f2--){
            $f = ($f1 * 10) + $f2 ;
            $texto = "" ;
            for($i=1;$i<6;$i++){
                $texto .=  substr($barcodes[$f1],($i-1),1) . substr($barcodes[$f2],($i-1),1);
            }
            $barcodes[$f] = $texto;
        }
    }


//Desenho da barra


//Guarda inicial
    ?><img src=imagens/p.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img
        src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img
        src=imagens/p.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img
        src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img
    <?php
    $texto = $valor ;
    if((strlen($texto) % 2) <> 0){
        $texto = "0" . $texto;
    }

// Draw dos dados
    while (strlen($texto) > 0) {
        $i = round(esquerda($texto,2));
        $texto = direita($texto,strlen($texto)-2);
        $f = $barcodes[$i];
        for($i=1;$i<11;$i+=2){
            if (substr($f,($i-1),1) == "0") {
                $f1 = $fino ;
            }else{
                $f1 = $largo ;
            }
            ?>
            src=imagens/p.png width=<?php echo $f1?> height=<?php echo $altura?> border=0><img
                <?php
                if (substr($f,$i,1) == "0") {
                    $f2 = $fino ;
                }else{
                    $f2 = $largo ;
                }
                ?>
                src=imagens/b.png width=<?php echo $f2?> height=<?php echo $altura?> border=0><img
        <?php
        }
    }

// Draw guarda final
    ?>
    src=imagens/p.png width=<?php echo $largo?> height=<?php echo $altura?> border=0><img
        src=imagens/b.png width=<?php echo $fino?> height=<?php echo $altura?> border=0><img
        src=imagens/p.png width=<?php echo 1?> height=<?php echo $altura?> border=0>
<?php
} //Fim da funo

function esquerda($entra,$comp){
    return substr($entra,0,$comp);
}

function direita($entra,$comp){
    return substr($entra,strlen($entra)-$comp,$comp);
}

function fator_vencimento($data)
{
    $data = explode("/", $data);
    $ano = $data[2];
    $mes = $data[1];
    $dia = $data[0];
    $resultado = (abs((_dateToDays("1997", "10", "07")) - (_dateToDays($ano, $mes, $dia))));
    if ($resultado > 9999) {
        $resultado = (abs((_dateToDays("2025", "02", "22")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
        if ($resultado > 9999) {
            $resultado = (abs((_dateToDays("2052", "07", "08")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
            if ($resultado > 9999) {
                $resultado = (abs((_dateToDays("2079", "11", "23")) - (_dateToDays($ano, $mes, $dia)))) + 1000;
            }
        }
    }
    return $resultado;
}

function _dateToDays($year,$month,$day) {
    $century = substr($year, 0, 2);
    $year = substr($year, 2, 2);
    if ($month > 2) {
        $month -= 3;
    } else {
        $month += 9;
        if ($year) {
            $year--;
        } else {
            $year = 99;
            $century --;
        }
    }
    return ( floor((  146097 * $century)    /  4 ) +
        floor(( 1461 * $year)        /  4 ) +
        floor(( 153 * $month +  2) /  5 ) +
        $day +  1721119);
}

/*
#################################################
FUNO DO MDULO 10 RETIRADA DO PHPBOLETO

ESTA FUNO PEGA O DGITO VERIFICADOR DO PRIMEIRO, SEGUNDO
E TERCEIRO CAMPOS DA LINHA DIGITVEL
#################################################
*/
function modulo_10($num) {
    $numtotal10 = 0;
    $fator = 2;

    for ($i = strlen($num); $i > 0; $i--) {
        $numeros[$i] = substr($num,$i-1,1);
        $parcial10[$i] = $numeros[$i] * $fator;
        $numtotal10 .= $parcial10[$i];
        if ($fator == 2) {
            $fator = 1;
        }
        else {
            $fator = 2;
        }
    }

    $soma = 0;
    for ($i = strlen($numtotal10); $i > 0; $i--) {
        $numeros[$i] = substr($numtotal10,$i-1,1);
        $soma += $numeros[$i];
    }
    $resto = $soma % 10;
    $digito = 10 - $resto;
    if ($resto == 0) {
        $digito = 0;
    }

    return $digito;
}

/*
#################################################
FUNO DO MDULO 11 RETIRADA DO PHPBOLETO

MODIFIQUEI ALGUMAS COISAS...

ESTA FUNO PEGA O DGITO VERIFICADOR:

NOSSONUMERO
AGENCIA
CONTA
CAMPO 4 DA LINHA DIGITVEL
#################################################
*/

function modulo_11($num, $base=9, $r=0) {
    $soma = 0;
    $fator = 2;
    for ($i = strlen($num); $i > 0; $i--) {
        $numeros[$i] = substr($num,$i-1,1);
        $parcial[$i] = $numeros[$i] * $fator;
        $soma += $parcial[$i];
        if ($fator == $base) {
            $fator = 1;
        }
        $fator++;
    }
    if ($r == 0) {
        $soma *= 10;
        $digito = $soma % 11;

        //corrigido
        if ($digito == 10) {
            $digito = "X";
        }

        /*
        alterado por mim, Daniel Schultz

        Vamos explicar:

        O mdulo 11 s gera os digitos verificadores do nossonumero,
        agencia, conta e digito verificador com codigo de barras (aquele que fica sozinho e triste na linha digitvel)
        s que  foi um rolo...pq ele nao podia resultar em 0, e o pessoal do phpboleto se esqueceu disso...

        No BB, os dgitos verificadores podem ser X ou 0 (zero) para agencia, conta e nosso numero,
        mas nunca pode ser X ou 0 (zero) para a linha digitvel, justamente por ser totalmente numrica.

        Quando passamos os dados para a funo, fica assim:

        Agencia = sempre 4 digitos
        Conta = at 8 dgitos
        Nosso nmero = de 1 a 17 digitos

        A unica varivel que passa 17 digitos  a da linha digitada, justamente por ter 43 caracteres

        Entao vamos definir ai embaixo o seguinte...

        se (strlen($num) == 43) { no deixar dar digito X ou 0 }
        */

        if (strlen($num) == "43") {
            //ento estamos checando a linha digitvel
            if ($digito == "0" or $digito == "X" or $digito > 9) {
                $digito = 1;
            }
        }
        return $digito;
    }
    elseif ($r == 1){
        $resto = $soma % 11;
        return $resto;
    }
}

/*
Montagem da linha digitvel - Funo tirada do PHPBoleto
No mudei nada
*/
function monta_linha_digitavel($linha) {
    // Posio 	Contedo
    // 1 a 3    Nmero do banco
    // 4        Cdigo da Moeda - 9 para Real
    // 5        Digito verificador do Cdigo de Barras
    // 6 a 19   Valor (12 inteiros e 2 decimais)
    // 20 a 44  Campo Livre definido por cada banco

    // 1. Campo - composto pelo cdigo do banco, cdigo da moda, as cinco primeiras posies
    // do campo livre e DV (modulo10) deste campo
    $p1 = substr($linha, 0, 4);
    $p2 = substr($linha, 19, 5);
    $p3 = modulo_10("$p1$p2");
    $p4 = "$p1$p2$p3";
    $p5 = substr($p4, 0, 5);
    $p6 = substr($p4, 5);
    $campo1 = "$p5.$p6";

    // 2. Campo - composto pelas posioes 6 a 15 do campo livre
    // e livre e DV (modulo10) deste campo
    $p1 = substr($linha, 24, 10);
    $p2 = modulo_10($p1);
    $p3 = "$p1$p2";
    $p4 = substr($p3, 0, 5);
    $p5 = substr($p3, 5);
    $campo2 = "$p4.$p5";

    // 3. Campo composto pelas posicoes 16 a 25 do campo livre
    // e livre e DV (modulo10) deste campo
    $p1 = substr($linha, 34, 10);
    $p2 = modulo_10($p1);
    $p3 = "$p1$p2";
    $p4 = substr($p3, 0, 5);
    $p5 = substr($p3, 5);
    $campo3 = "$p4.$p5";

    // 4. Campo - digito verificador do codigo de barras
    $campo4 = substr($linha, 4, 1);

    // 5. Campo composto pelo valor nominal pelo valor nominal do documento, sem
    // indicacao de zeros a esquerda e sem edicao (sem ponto e virgula). Quando se
    // tratar de valor zerado, a representacao deve ser 000 (tres zeros).
    $campo5 = substr($linha, 5, 14);

    return "$campo1 $campo2 $campo3 $campo4 $campo5";
}

function geraCodigoBanco($numero) {
    $parte1 = substr($numero, 0, 3);
    $parte2 = modulo_11($parte1);
    return $parte1 . "-" . $parte2;
}

?>
