<?php
// +----------------------------------------------------------------------+
// | BoletoPhp - Versao Beta                                              |
// +----------------------------------------------------------------------+
// | Este arquivo esta disponivel sob a Licenca GPL disponivel pela Web   |
// | em http://pt.wikipedia.org/wiki/GNU_General_Public_License           |
// | Voce deve ter recebido uma copia da GNU Public License junto com     |
// | esse pacote; se nao, escreva para:                                   |
// |                                                                      |
// | Free Software Foundation, Inc.                                       |
// | 59 Temple Place - Suite 330                                          |
// | Boston, MA 02111-1307, USA.                                          |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Originado do Projeto BBBoletoFree que tiveram colaboracaes de Daniel |
// | William Schultz e Leandro Maniezo que por sua vez foi derivado do	  |
// | PHPBoleto de Joao Prado Maia e Pablo Martins F. Costa				        |
// | 														                                   			  |
// | Se vc quer colaborar, nos ajude a desenvolver p/ os demais bancos :-)|
// | Acesse o site do Projeto BoletoPhp: www.boletophp.com.br             |
// +----------------------------------------------------------------------+

// +----------------------------------------------------------------------+
// | Equipe Coordenacao Projeto BoletoPhp: <boletophp@boletophp.com.br>   |
// | Desenvolvimento Boleto Itau: Glauber Portella                        |
// +----------------------------------------------------------------------+


// ------------------------- DADOS DINAMICOS DO SEU CLIENTE PARA A GERACAO DO BOLETO (FIXO OU VIA GET) -------------------- //
// Os valores abaixo podem ser colocados manualmente ou ajustados p/ formulario c/ POST, GET ou de BD (MySql,Postgre,etc)	//

// DADOS DO BOLETO PARA O SEU CLIENTE
$dias_de_prazo_para_pagamento = isset($_POST['dias_prazo_pagamento']) ? $_POST['dias_prazo_pagamento'] : 0;
$taxa_boleto = $_POST['taxa_boleto'];
$data_venc = $_POST['vencimento'];  // Prazo de X dias OU informe data: "13/04/2006";
$valor_cobrado = $_POST['valor_cobrado']; // Valor - REGRA: Sem pontos na milhar e tanto faz com "." ou "," ou com 1 ou 2 ou sem casa decimal
$desconto = (isset($_POST['desconto'])) ? ($_POST['desconto'] > 0 ? $_POST['desconto'] : '') : '';
$desc = number_format($desconto, 2, ',', '');
$acrescimo = (isset($_POST['acrescimo'])) ? ($_POST['acrescimo'] > 0 ? $_POST['acrescimo'] : 0) : 0;
$valor_cobrado = ($valor_cobrado - $desconto + $acrescimo);
$valor_cobrado = str_replace(",", ".", $valor_cobrado);
$valor_boleto = number_format($valor_cobrado + $taxa_boleto, 2, ',', '');

$dadosboleto["nosso_numero"] = str_pad((int)$_POST['nosso_numero'], 8, '0', STR_PAD_LEFT);  // Nosso numero - REGRA: Maximo de 8 caracteres!

// DADOS DO EMPREENDIMENTO
$dadosboleto["nm_empreendimento"] = $_POST["identificacao"];
$dadosboleto["nr_contrato"] = $_POST["nr_contrato"];
$dadosboleto["lote"] = $_POST["lote"];
$dadosboleto["quadra"] = $_POST["quadra"];
$dadosboleto["tp_parcela"] = $_POST["tp_parcela"];
$dadosboleto["nr_parcela"] = $_POST["nr_parcela"];
$dadosboleto["ds_grupo"] = $_POST["ds_grupo"];
$dadosboleto["ds_subgrupo"] = $_POST["ds_subgrupo"];

$dadosboleto["numero_documento"] = str_pad((int)$_POST['numero_documento'], 8, '0', STR_PAD_LEFT);    // Num do pedido ou do documento
$dadosboleto["data_vencimento"] = $data_venc; // Data de Vencimento do Boleto - REGRA: Formato DD/MM/AAAA
$dadosboleto["data_documento"] = date("d/m/Y"); // Data de emissao do Boleto
$dadosboleto["data_processamento"] = date("d/m/Y"); // Data de processamento do boleto (opcional)
$dadosboleto["valor_boleto"] = $valor_boleto;    // Valor do Boleto - REGRA: Com virgula e sempre com duas casas depois da virgula

// DADOS DO SEU CLIENTE
$dadosboleto["sacado"] = $_POST['sacado'];
$dadosboleto["endereco1"] = $_POST['endereco1'];
$dadosboleto["endereco2"] = $_POST['endereco2'];

// INFORMACOES PARA O CLIENTE
$dadosboleto["demonstrativo1"] = $_POST['demonstrativo1'];
$dadosboleto["demonstrativo2"] = $_POST['demonstrativo2'];
$dadosboleto["demonstrativo3"] = $_POST['demonstrativo3'];

// INSTRUCOES PARA O CAIXA
$dadosboleto["instrucoes1"] = isset($_POST['instrucoes1']) ? $_POST['instrucoes1'] : '';
$dadosboleto["instrucoes2"] = isset($_POST['instrucoes2']) ? $_POST['instrucoes2'] : '';
$dadosboleto["instrucoes3"] = isset($_POST['instrucoes3']) ? $_POST['instrucoes3'] : '';
$dadosboleto["instrucoes4"] = isset($_POST['instrucoes4']) ? $_POST['instrucoes4'] : '';

// DADOS OPCIONAIS DE ACORDO COM O BANCO OU CLIENTE
$dadosboleto["quantidade"] = "";
$dadosboleto["valor_unitario"] = "";
$dadosboleto["especie"] = "R$";
$dadosboleto["especie_doc"] = $_POST["especie_doc"];


// ---------------------- DADOS FIXOS DE CONFIGURACAO DO SEU BOLETO --------------- //


// DADOS DA SUA CONTA - ITAU
$dadosboleto["agencia"] = $_POST['agencia']; // Num da agencia, sem digito
$dadosboleto["conta"] = $_POST['conta'];    // Num da conta, sem digito
$dadosboleto["conta_dv"] = $_POST['conta_dv'];    // Digito do Num da conta

// DADOS PERSONALIZADOS - ITAU
$dadosboleto["carteira"] = $_POST['carteira'];  // Codigo da Carteira: pode ser 175, 174, 104, 109, 178, ou 157

// SEUS DADOS
$dadosboleto["identificacao"] = $_POST['identificacao'];
$dadosboleto["cpf_cnpj"] = $_POST['cpf_cnpj'];
$dadosboleto["endereco"] = $_POST['endereco'];
$dadosboleto["cidade_uf"] = $_POST['cidade_uf'];
$dadosboleto["cedente"] = $_POST['cedente'];

$dadosboleto["localPagamento"] = 'AT O VENCIMENTO, PREFERENCIALMENTE NO ITA APS O VENCIMENTO, SOMENTE NO ITA';

include("include/funcoes_itau.php");

if($_POST['modelo'] == 'C') {
    include("include/layout_itau.php"); //layout carne
} else {
    include("include/layoutTodosBancos.php");//layou ficha compensacao
}
